/*
 * main.cpp
 *
 *  Created on: May 9, 2015
 *      Author: jcmx9
 */

#include "cv.h"
#include "highgui.h"
#include <stdio.h>

int main(int argc, char** argv) {
    //initiate a openCV Window and name it as "Capture Image"
    cvNamedWindow("Capture Image");

    //allocates and initialized the CvCapture structure for reading a video stream from the camera.
    CvCapture* capture = cvCreateCameraCapture(0);
    //The IplImage is taken from the Intel Image Processing Library, in which the format is native.
    //supported by OpenCV
    IplImage* frame;

    while(1) {
        printf ("\nPress <ENTER> key to capture.\n");
        //block the program until <ENTER> key press
        //when <ENTER> key press, a line will be read by getchar()
        getchar();
        //grabs a frame from camera, decompresses it
        frame = cvQueryFrame(capture);
        //if no frame was caught, there is an error, bread the while loop incase
        //future pointer error
        if(!frame)
            break;
        //shows the image in the specified window
        //image is scaled to fit the window by default
        cvShowImage("Capture Image", frame);

        //NECESSARY! highgui is never given time to process the draw requests
        //if no cvWaitKey is applied here

        //waits for key event for 50 milliseconds,
        //return -1 if no key is pressed
        char c = cvWaitKey(50);
        //when <ECS> is hit in the window "Capture Image",
        //bread while loop to stop the program
        if(c==27)
            break;
    }

    //releases allocated CvCapture structure
    cvReleaseCapture(&capture);
    //destroy the window with a giver name "Capture Image"
    cvDestroyWindow("Capture Image");
    return 0;
}
